
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE

	MSGFINAL TEXT := 'FOI CRIADA';
	
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'pdv_vd_it_rec') THEN 

CREATE TABLE pdv_vd_it_rec
(
    cd_emp numeric(6,0) NOT NULL DEFAULT 0,
    cd_filial numeric(6,0) NOT NULL DEFAULT 0,
    cd_it numeric(6,0) NOT NULL DEFAULT 0,
    cd_prod numeric(10,0) NOT NULL DEFAULT 0,
    cd_vd numeric(10,0) NOT NULL DEFAULT 0,
    dt_cad date NOT NULL DEFAULT ('now'::text)::date,
    cd_medico_rec integer NOT NULL,
    cd_vend integer NOT NULL,
    qt_prod integer NOT NULL,
    flag_consolidado integer DEFAULT 0,
    nr_receita integer,
    dt_receita timestamp(6) without time zone,
    cd_receita integer,
    tp_capt_receita character(1) COLLATE pg_catalog."default",
    nm_comprador character varying(100) COLLATE pg_catalog."default",
    idade integer,
    nm_paciente character varying(100) COLLATE pg_catalog."default",
    receita_tipo integer,
    cid integer,
    uf character varying(4) COLLATE pg_catalog."default",
    nr_doc_cli character varying COLLATE pg_catalog."default",
    tipo_documento integer,
    tp_doc_exp integer,
    sexo integer,
    uso_prolong integer,
    cd_tp_class_anvisa integer,
    nm_medico character varying(100) COLLATE pg_catalog."default" DEFAULT ''::character varying,
    uf_medico character varying(4) COLLATE pg_catalog."default",
    nr_doc_medico character varying COLLATE pg_catalog."default",
    unidade_idade integer,
    cd_orgao_exp integer,
    CONSTRAINT pdv_vd_it_rec_pkey PRIMARY KEY (cd_emp, cd_filial, cd_vd, cd_it)
);
	ELSE    
		MSGFINAL := 'A TABELA J EXISTE';
	END IF;

	RAISE NOTICE 'TABELA pdv_vd_it_rec %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();